/*
 *              @(#)signal.h    1.6     (ULTRIX)        10/21/85
 *      signal.h        6.1     83/08/14
 */

/************************************************************************
 *                                                                      *
 *                      Copyright (c) 1985 by                           *
 *              Digital Equipment Corporation, Maynard, MA              *
 *                      All rights reserved.                            *
 *                                                                      *
 *   This software is furnished under a license and may be used and     *
 *   copied  only  in accordance with the terms of such license and     *
 *   with the  inclusion  of  the  above  copyright  notice.   This     *
 *   software  or  any  other copies thereof may not be provided or     *
 *   otherwise made available to any other person.  No title to and     *
 *   ownership of the software is hereby transferred.                   *
 *                                                                      *
 *   This software is  derived  from  software  received  from  the     *
 *   University    of   California,   Berkeley,   and   from   Bell     *
 *   Laboratories.  Use, duplication, or disclosure is  subject  to     *
 *   restrictions  under  license  agreements  with  University  of     *
 *   California and with AT&T.                                          *
 *                                                                      *
 *   The information in this software is subject to change  without     *
 *   notice  and should not be construed as a commitment by Digital     *
 *   Equipment Corporation.                                             *
 *                                                                      *
 *   Digital assumes no responsibility for the use  or  reliability     *
 *   of its software on equipment which is not supplied by Digital.     *
 *                                                                      *
 ************************************************************************/
/************************************************************************
 *                      Modification History                            *
 *                                                                      *
 *      Larry Cohen 10/1/85                                             *
 *              Add SIGWINCH - window change signal                     *
 *                                                                      *
 *      Greg Depp  25 Jun 85                                            *
 *      Moved SIGUSR1 and SIGUSR2 to 30 and 31 to conform with Berkeley *
 *                                                                      *
 *      David L Ballenger, 28-Mar-1985                                  *
 * 0001 Add definitions for System V compatibility                      *
 *                                                                      *
 ************************************************************************/

#ifndef NSIG
#define NSIG    32

#define SIGHUP  1       /* hangup */
#define SIGINT  2       /* interrupt */
#define SIGQUIT 3       /* quit */
#define SIGILL  4       /* illegal instruction (not reset when caught) */
#define     ILL_RESAD_FAULT     0x0     /* reserved addressing fault */
#define     ILL_PRIVIN_FAULT    0x1     /* privileged instruction fault */
#define     ILL_RESOP_FAULT     0x2     /* reserved operand fault */
/* CHME, CHMS, CHMU are not yet given back to users reasonably */
#define SIGTRAP 5       /* trace trap (not reset when caught) */
#define SIGIOT  6       /* IOT instruction */
#define SIGEMT  7       /* EMT instruction */
#define SIGFPE  8       /* floating point exception */
#define     FPE_INTOVF_TRAP     0x1     /* integer overflow */
#define     FPE_INTDIV_TRAP     0x2     /* integer divide by zero */
#define     FPE_FLTOVF_TRAP     0x3     /* floating overflow */
#define     FPE_FLTDIV_TRAP     0x4     /* floating/decimal divide by zero */
#define     FPE_FLTUND_TRAP     0x5     /* floating underflow */
#define     FPE_DECOVF_TRAP     0x6     /* decimal overflow */
#define     FPE_SUBRNG_TRAP     0x7     /* subscript out of range */
#define     FPE_FLTOVF_FAULT    0x8     /* floating overflow fault */
#define     FPE_FLTDIV_FAULT    0x9     /* divide by zero floating fault */
#define     FPE_FLTUND_FAULT    0xa     /* floating underflow fault */
#define SIGKILL 9       /* kill (cannot be caught or ignored) */
#define SIGBUS  10      /* bus error */
#define SIGSEGV 11      /* segmentation violation */
#define SIGSYS  12      /* bad argument to system call */
#define SIGPIPE 13      /* write on a pipe with no one to read it */
#define SIGALRM 14      /* alarm clock */
#define SIGTERM 15      /* software termination signal from kill */
#define SIGURG  16      /* urgent condition on IO channel */
#define SIGSTOP 17      /* sendable stop signal not from tty */
#define SIGTSTP 18      /* stop signal from tty */
#define SIGCONT 19      /* continue a stopped process */
#define SIGCHLD 20      /* to parent on child stop or exit */
#define SIGTTIN 21      /* to readers pgrp upon background tty read */
#define SIGTTOU 22      /* like TTIN for output if (tp->t_local&LTOSTOP) */
#define SIGIO   23      /* input/output possible signal */
#define SIGXCPU 24      /* exceeded CPU time limit */
#define SIGXFSZ 25      /* exceeded file size limit */
#define SIGVTALRM 26    /* virtual time alarm */
#define SIGPROF 27      /* profiling time alarm */
#define SIGWINCH 28     /* window size changes */
                        /* 29 = undefined */
#define SIGUSR1 30      /* User signal (from SysV) */
#define SIGUSR2 31      /* User signal (from SysV) */

/* Add System V signal definitions (DLB001)
 */
#define SIGCLD  SIGCHLD /* System V name for SIGCHLD    */
#define SIGABRT SIGIOT  /* Added from BRL package for /usr/group. Signal
                         * returned by abort(3C).  Map onto SIGIOT.
                         */
#define SIGPWR  -1      /* Not supported on ULTRIX, make sure it is an
                         * illegal signal value.
                         */

#ifndef SYSTEM_FIVE
/*
 * Signal vector "template" used in sigvec call.
 */
struct  sigvec {
        int     (*sv_handler)();        /* signal handler */
        int     sv_mask;                /* signal mask to apply */
        int     sv_onstack;             /* if non-zero, take on signal stack */
};

/*
 * Structure used in sigstack call.
 */
struct  sigstack {
        char    *ss_sp;                 /* signal stack pointer */
        int     ss_onstack;             /* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */
struct  sigcontext {
        int     sc_onstack;             /* sigstack state to restore */
        int     sc_mask;                /* signal mask to restore */
        int     sc_sp;                  /* sp to restore */
        int     sc_pc;                  /* pc to retore */
        int     sc_ps;                  /* psl to restore */
};
#endif  SYSTEM_FIVE

#define BADSIG          (int (*)())-1
#define SIG_DFL         (int (*)())0
#define SIG_IGN         (int (*)())1

#ifdef KERNEL
#define SIG_CATCH       (int (*)())2
#define SIG_HOLD        (int (*)())3
#else KERNEL
extern int      (*signal())();
#endif KERNAL
#endif NSIG
